/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.infrastructure.ponder.scenes.fluid;

import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.contraptions.actors.psi.PortableFluidInterfaceBlockEntity;
import com.zurrtum.create.content.fluids.pump.PumpBlock;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3611;

@Environment(value=EnvType.CLIENT)
public class FluidMovementActorScenes {
    public static void transfer(SceneBuilder builder, SceneBuildingUtil util) {
        int i;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("portable_fluid_interface", "Contraption Fluid Exchange");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.95f);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        scene.idle(5);
        Selection pipes = util.select().fromTo(2, 1, 3, 0, 1, 3).add(util.select().position(0, 1, 4));
        class_2338 pumpPos = util.grid().at(0, 1, 4);
        Selection kinetics = util.select().fromTo(1, 1, 7, 1, 1, 4);
        Selection tank = util.select().fromTo(0, 1, 5, 0, 3, 5);
        Selection largeCog = util.select().position(2, 0, 7);
        FluidStack chocolate = new FluidStack((class_3611)AllFluids.CHOCOLATE, 81000);
        class_2338 ct1 = util.grid().at(5, 3, 2);
        class_2338 ct2 = util.grid().at(6, 3, 2);
        class_2338 st = util.grid().at(0, 1, 5);
        Class<FluidTankBlockEntity> type = FluidTankBlockEntity.class;
        class_1799 bucket = AllItems.CHOCOLATE_BUCKET.method_7854();
        scene.world().modifyBlock(pumpPos, s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11043), false);
        scene.world().modifyBlockEntity(st, type, be -> be.getTankInventory().insert(chocolate, 810000));
        class_2338 bearing = util.grid().at(5, 1, 2);
        scene.world().showSection(util.select().position(bearing), class_2350.field_11033);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(util.select().fromTo(5, 2, 2, 6, 4, 2), class_2350.field_11033);
        scene.world().configureCenterOfRotation(contraption, util.vector().centerOf(bearing));
        scene.idle(10);
        scene.world().rotateBearing(bearing, 360.0f, 70);
        scene.world().rotateSection(contraption, 0.0, 360.0, 0.0, 70);
        scene.overlay().showText(60).pointAt(util.vector().topOf(bearing.method_10086(2))).colored(PonderPalette.RED).placeNearTarget().attachKeyFrame().text("Fluid Tanks on moving contraptions cannot be accessed by any pipes");
        scene.idle(70);
        class_2338 psi = util.grid().at(4, 2, 2);
        scene.world().showSectionAndMerge(util.select().position(psi), class_2350.field_11034, contraption);
        scene.idle(13);
        scene.effects().superGlue(psi, class_2350.field_11034, true);
        scene.overlay().showText(80).pointAt(util.vector().topOf(psi)).colored(PonderPalette.GREEN).placeNearTarget().attachKeyFrame().text("This component can interact with fluid tanks without the need to stop the contraption");
        scene.idle(90);
        class_2338 psi2 = psi.method_10088(2);
        scene.world().showSection(util.select().position(psi2), class_2350.field_11033);
        scene.overlay().showOutlineWithText(util.select().position(psi.method_10067()), 50).colored(PonderPalette.RED).placeNearTarget().attachKeyFrame().text("Place a second one with a gap of 1 or 2 blocks inbetween");
        scene.idle(55);
        scene.world().rotateBearing(bearing, 360.0f, 60);
        scene.world().rotateSection(contraption, 0.0, 360.0, 0.0, 60);
        scene.idle(20);
        scene.overlay().showText(40).placeNearTarget().pointAt(util.vector().of(3.0, 3.0, 2.5)).text("Whenever they pass by each other, they will engage in a connection");
        scene.idle(38);
        Selection both = util.select().fromTo(2, 2, 2, 4, 2, 2);
        Class<PortableFluidInterfaceBlockEntity> psiClass = PortableFluidInterfaceBlockEntity.class;
        scene.world().modifyBlockEntityNBT(both, psiClass, nbt -> {
            nbt.method_10548("Distance", 1.0f);
            nbt.method_10548("Timer", 14.0f);
        });
        scene.idle(17);
        scene.overlay().showOutline(PonderPalette.GREEN, psi, util.select().fromTo(5, 3, 2, 6, 4, 2), 80);
        scene.idle(10);
        scene.overlay().showOutlineWithText(util.select().position(psi2), 70).placeNearTarget().colored(PonderPalette.GREEN).attachKeyFrame().text("While engaged, the stationary interface will represent ALL Tanks on the contraption");
        scene.idle(80);
        ElementLink<WorldSectionElement> p = scene.world().showIndependentSection(tank, class_2350.field_11033);
        scene.world().moveSection(p, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.idle(5);
        scene.world().showSectionAndMerge(pipes, class_2350.field_11034, p);
        scene.idle(5);
        scene.world().showSectionAndMerge(largeCog, class_2350.field_11036, p);
        scene.world().showSectionAndMerge(kinetics, class_2350.field_11043, p);
        scene.idle(10);
        scene.overlay().showText(70).placeNearTarget().pointAt(util.vector().topOf(pumpPos)).attachKeyFrame().text("Fluid can now be inserted...");
        scene.idle(30);
        for (i = 0; i < 16; ++i) {
            if (i == 8) {
                scene.overlay().showControls(util.vector().blockSurface(util.grid().at(5, 3, 2), class_2350.field_11039).method_1031(0.0, 0.5, 0.0), Pointing.LEFT, 30).withItem(bucket);
            }
            scene.world().modifyBlockEntity(st, type, be -> be.getTankInventory().extract(chocolate, 81000));
            scene.world().modifyBlockEntity(ct1, type, be -> be.getTankInventory().insert(chocolate));
            scene.idle(2);
        }
        for (i = 0; i < 8; ++i) {
            scene.world().modifyBlockEntity(st, type, be -> be.getTankInventory().extract(chocolate, 81000));
            scene.world().modifyBlockEntity(ct2, type, be -> be.getTankInventory().insert(chocolate));
            scene.idle(2);
        }
        scene.idle(50);
        scene.overlay().showText(40).placeNearTarget().pointAt(util.vector().topOf(pumpPos)).text("...or extracted from the contraption");
        scene.world().modifyBlock(pumpPos, s -> (class_2680)s.method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11035), true);
        scene.world().propagatePipeChange(pumpPos);
        scene.idle(30);
        for (i = 0; i < 8; ++i) {
            scene.world().modifyBlockEntity(ct2, type, be -> be.getTankInventory().extract(chocolate, 81000));
            scene.world().modifyBlockEntity(st, type, be -> be.getTankInventory().insert(chocolate));
            scene.idle(2);
        }
        for (i = 0; i < 16; ++i) {
            scene.world().modifyBlockEntity(ct1, type, be -> be.getTankInventory().extract(chocolate, 81000));
            scene.world().modifyBlockEntity(st, type, be -> be.getTankInventory().insert(chocolate));
            scene.idle(2);
        }
        scene.world().modifyBlockEntity(util.grid().at(2, 2, 3), type, be -> be.getTankInventory().extract(chocolate, 648000));
        scene.idle(50);
        scene.overlay().showText(120).placeNearTarget().attachKeyFrame().pointAt(util.vector().topOf(psi2)).text("After no contents have been exchanged for a while, the contraption will continue on its way");
        scene.world().modifyBlockEntityNBT(both, psiClass, nbt -> nbt.method_10548("Timer", 2.0f));
        scene.idle(15);
        scene.world().rotateBearing(bearing, 270.0f, 120);
        scene.world().rotateSection(contraption, 0.0, 270.0, 0.0, 120);
        scene.idle(100);
        scene.markAsFinished();
    }
}

